# @summary Installs Conda
#
# If anaconda is not already installed, installs conda and python via the lightweight miniconda installer.
#
# @example
#   include anaconda::install
class anaconda::install {
  exec { 'downloadconda':
    creates => '/opt/miniconda.sh',
    command => 'wget https://repo.continuum.io/miniconda/Miniconda3-3.7.0-latest-x86_64.sh -O /opt/miniconda.sh',
    path    => ['/usr/bin'],
  }

  exec { 'initialinstallconda':
    creates => '/opt/miniconda/bin/activate',
    command => 'bash /opt/miniconda.sh -b -p /opt/miniconda',
    path    => ['/bin' , '/usr/bin'],
    require => Exec['downloadconda'],
  }
}