# @summary Generates and ensures the presence of environments in the Anaconda Installation
#
# Generates and ensures the presence of environments in the Anaconda Installation
#
# @example
#   include anaconda::environments
class anaconda::environments {

  file { '/opt/envs':
    ensure  => directory,
  }

  file { '/opt/envs/vanilla3.yml':
    ensure  => present,
    source  => 'puppet:///modules/anaconda/vanilla3.yml',
    require => File['/opt/envs'],
  }

  exec { 'setupvanilla3':
    unless  => "conda env list | grep -q 'vanilla3'",
    command => 'conda env create -f /opt/envs/vanilla3.yml',
    require => File['/opt/envs/vanilla3.yml'],
    path    => ['/bin','/opt/miniconda/bin']
  }
  
  file { '/opt/envs/tensorflow.yml':
    ensure  => present,
    source  => 'puppet:///modules/anaconda/tensorflow.yml',
    require => File['/opt/envs'],
  }

  exec { 'setuptensorflow':
    unless  => "conda env list | grep -q 'tensorflow'",
    command => 'conda env create -f /opt/envs/tensorflow.yml',
    require => File['/opt/envs/tensorflow.yml'],
    path    => ['/bin','/opt/miniconda/bin']
  }
  
  file { '/opt/envs/tensorflow-gpu.yml':
    ensure  => present,
    source  => 'puppet:///modules/anaconda/tensorflow-gpu.yml',
    require => File['/opt/envs'],
  }

  exec { 'setuptensorflow-gpu':
    unless  => "conda env list | grep -q 'tensorflow-gpu'",
    command => 'conda env create -f /opt/envs/tensorflow-gpu.yml',
    require => [File['/opt/envs/tensorflow-gpu.yml'], Exec['setuptensorflow']],
    path    => ['/bin','/opt/miniconda/bin']
  }
  
  file { '/opt/envs/bioinformatics.yml':
    ensure  => present,
    source  => 'puppet:///modules/anaconda/bioinformatics.yml',
    require => File['/opt/envs'],
  }
  
  exec {'setbioinformaticschannels':
    command => 'conda config --add channels defaults,bioconda,conda-forge'
    require => File['/opt/envs/bioinformatics.yml']
    path    => ['/bin','/opt/miniconda/bin']
  }

  exec { 'setupbioinformatics':
    unless  => "conda env list | grep -q 'bioinformatics'",
    command => 'conda env create -f /opt/envs/bioinformatics.yml',
    require => [File['/opt/envs/bioinformatics.yml'], Exec['setbioinformaticschannels']],
    path    => ['/bin','/opt/miniconda/bin']
  }

}
