# @summary Installs Conda
#
# If anaconda is not already installed, installs conda and python via the lightweight miniconda installer.
#
# @example
#   include anaconda::install
class anaconda::install {
  exec { 'downloadconda':
    creates => '/miniconda.sh',
    command => 'wget https://repo.continuum.io/miniconda/Miniconda3-3.7.0-Linux-x86_64.sh -O /miniconda.sh',
    path    => ['/usr/bin'],
  }

  exec { 'initalinstallconda':
    creates => '/miniconda/bin/activate',
    command => 'bash /miniconda.sh -b -p /miniconda',
    path    => ['/bin' , '/usr/bin'],
    require => Exec['downloadconda'],
  }

  exec { 'ensurecondainpath':
    unless  => 'echo $PATH | grep /miniconda/bin',
    command => 'export PATH="/miniconda/bin:$PATH"',
    require => Exec['initialinstallconda'],
  }  
}