# @summary Generates and ensures the presence of environments in the Anaconda Installation
#
# Generates and ensures the presence of environments in the Anaconda Installation
#
# @example
#   include anaconda::environments
class anaconda::environments {

  file { 'environment1.yml': #temporary name
    ensure   => present,
    content  => '', #content required to generate desire environment
    require  => Exec['initialinstallconda'],
  }

  exec { 'setupenvironment1':
    unless   => "conda env list | grep -q 'environment1'"
    command  => 'conda env create -f environment1.yml'
    require  => File[environment1.yml],
  }

}
