# @summary Installs Conda
#
# If anaconda is not already installed, installs conda and python via the lightweight miniconda installer.
#
# @example
#   include anaconda::install
class anaconda::install {
  exec { 'downloadconda':
    creates => '/opt/anaconda.sh',
    command => 'wget https://repo.continuum.io/archive/Anaconda3-2019.10-Linux-x86_64.sh -O /opt/anaconda.sh',
    path    => ['/usr/bin'],
  }

  exec { 'initialinstallconda':
    creates => '/opt/anaconda/bin/activate',
    command => 'bash /opt/anaconda.sh -b -p /opt/anaconda',
    path    => ['/bin' , '/usr/bin'],
    require => Exec['downloadconda'],
  }
}