# @summary Generates and ensures the presence of environments in the Anaconda Installation
#
# Generates and ensures the presence of environments in the Anaconda Installation
#
# @example
#   include anaconda::environments
class anaconda::environments {

  file { '/opt/envs':
    ensure  => directory,
  }

  file { '/opt/envs/vanilla3.yml':
    ensure  => present,
    source  => 'puppet:///modules/anaconda/vanilla3.yml',
    require => File['/opt/envs'],
  }

  exec { 'setupvanilla3':
    unless  => "runuser -l local-machine -c '/opt/anaconda/bin/conda env list' | grep -q '/opt/anaconda/envs/vanilla3'",
    command => 'conda env create -f /opt/envs/vanilla3.yml',
    require => File['/opt/envs/vanilla3.yml'],
    path    => ['/bin','/sbin','/opt/anaconda/bin']
  }
  
  file { '/opt/envs/tensorflow.yml':
    ensure  => present,
    source  => 'puppet:///modules/anaconda/tensorflow.yml',
    require => File['/opt/envs'],
  }

  exec { 'setuptensorflow':
    unless  => "runuser -l local-machine -c '/opt/anaconda/bin/conda env list' | grep -q '/opt/anaconda/envs/tensorflow'",
    command => 'conda env create -f /opt/envs/tensorflow.yml',
    require => File['/opt/envs/tensorflow.yml'],
    path    => ['/bin','/sbin','/opt/anaconda/bin']
  }
  
  file { '/opt/envs/tensorflow-gpu.yml':
    ensure  => present,
    source  => 'puppet:///modules/anaconda/tensorflow-gpu.yml',
    require => File['/opt/envs'],
  }

  exec { 'setuptensorflow-gpu':
    unless  => "runuser -l local-machine -c '/opt/anaconda/bin/conda env list' | grep -q '/opt/anaconda/envs/tensorflow-gpu'",
    command => 'conda env create -f /opt/envs/tensorflow-gpu.yml',
    require => File['/opt/envs/tensorflow-gpu.yml'],
    path    => ['/bin','/sbin','/opt/anaconda/bin']
  }
  
  file { '/opt/envs/tensorflow2.yml':
    ensure  => present,
    source  => 'puppet:///modules/anaconda/tensorflow2.yml',
    require => File['/opt/envs'],
  }

  exec { 'setuptensorflow2':
    unless  => "runuser -l local-machine -c '/opt/anaconda/bin/conda env list' | grep -q '/opt/anaconda/envs/tensorflow2'",
    command => 'conda env create -f /opt/envs/tensorflow2.yml',
    require => File['/opt/envs/tensorflow2.yml'],
    path    => ['/bin','/sbin','/opt/anaconda/bin']
  }
  
  file { '/opt/envs/bioinformatics.yml':
    ensure  => present,
    source  => 'puppet:///modules/anaconda/bioinformatics.yml',
    require => File['/opt/envs'],
  }

  #exec { 'setupbioinformatics':
  #  unless  => "conda env list | grep -q '/opt/anaconda/envs/bioinformatics'",
  #  command => 'conda env create -f /opt/envs/bioinformatics.yml',
  #  require => File['/opt/envs/bioinformatics.yml'],
  #  path    => ['/bin','/opt/anaconda/bin']
  #}

}
