# @summary Generates and ensures the presence of environments in the Anaconda Installation
#
# Generates and ensures the presence of environments in the Anaconda Installation
#
# @example
#   include anaconda::environments
class anaconda::environments {

  file { '/opt/envs/vanilla3.yml':
    ensure => present,
    source => 'puppet:///modules/anaconda/data',
  }

  exec { 'setupvanilla3':
    unless  => "conda env list | grep -q 'vanilla3'",
    command => 'conda env create -f /opt/envs/vanilla3.yml',
    require => File['/opt/envs/vanilla3.yml'],
    path    => ['/bin','/opt/miniconda/bin']
  }

}
