class matlab::vardir {  # module vardir snippet
  if $::puppet_vardirtmp == '' {
    if $::puppet_vardir == '' {
      # here, we require that the puppetlabs fact exist!
      fail('Fact: $puppet_vardir is missing!')
    }
    $tmp = sprintf('%s/tmp/', regsubst($::puppet_vardir, '\/$', ''))
    # base directory where puppet modules can work and namespace in
    file { $tmp:
      ensure  => directory,  # make sure this is a directory
      recurse => false,  # don't recurse into directory
      purge   => true,    # purge all unmanaged files
      force   => true,    # also purge subdirs and links
      owner   => root,
      group   => nobody,
      mode    => '0600',
      backup  => false,  # don't backup to filebucket
      #before => File["${module_vardir}"],	# redundant
      #require => Package['puppet'],	# no puppet module seen
    }
  } else {
    $tmp = sprintf('%s/', regsubst($::puppet_vardirtmp, '\/$', ''))
  }
  $module_vardir = sprintf('%s/matlab/', regsubst($tmp, '\/$', ''))
  file { $module_vardir:    # /var/lib/puppet/tmp/matlab/
    ensure  => directory,    # make sure this is a directory
    recurse => true,    # recursively manage directory
    purge   => true,      # purge all unmanaged files
    force   => true,      # also purge subdirs and links
    owner   => root,
  group     => nobody,
  mode      => '0600',
  backup    => false,
    require => File[$tmp],  # File['/var/lib/puppet/tmp/']
  }
}